/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.core.tier;

import com.mojang.serialization.Codec;
import java.util.function.IntFunction;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.NotNull;

public enum ArrowTier implements StringRepresentable
{
    AMETHYST(0, "amethyst", 2.0f),
    BAMBOO(1, "bamboo", 1.0f),
    BLAZE_ROD(2, "blaze_rod", 5.0f),
    BONE(3, "bone", 2.0f),
    CACTUS(4, "cactus", 2.0f),
    COAL(5, "coal", 1.0f),
    COPPER(6, "copper", 2.5f),
    DIAMOND(7, "diamond", 5.0f),
    DRAGON_BREATH(8, "dragon_breath", 2.0f),
    DRIPSTONE(9, "dripstone", 1.5f),
    ECHO(10, "echo", 5.0f),
    EGG(11, "egg", 1.0f),
    EMERALD(12, "emerald", 5.0f),
    ENDER_PEARL(13, "ender_pearl", 4.0f),
    FIREWORK(14, "firework", 1.0f),
    FIRE_CHARGE(15, "fire_charge", 1.5f),
    FLINT(16, "flint", 1.5f),
    FLINT_AND_STEEL(17, "flint_and_steel", 2.0f),
    GLOW_INK_SAC(18, "glow_ink_sac", 1.0f),
    GOLD(19, "gold", 2.0f),
    ICE(20, "ice", 1.0f),
    INK_SAC(21, "ink_sac", 1.0f),
    IRON(22, "iron", 3.0f),
    LADDER(23, "ladder", 0.0f),
    LAPIS(24, "lapis", 2.0f),
    LIGHTNING_ROD(25, "lightning_rod", 3.0f),
    NETHERITE(26, "netherite", 6.0f),
    NETHER_QUARTZ(27, "nether_quartz", 2.0f),
    NETHER_STAR(28, "nether_star", 5.0f),
    OBSIDIAN(29, "obsidian", 5.0f),
    PAPER(30, "paper", 0.0f),
    PRISMARINE(31, "prismarine", 2.0f),
    REDSTONE(32, "redstone", 0.0f),
    SHEAR(33, "shear", 0.0f),
    SHULKER_SHELL(34, "shulker_shell", 0.0f),
    SLIMEBALL(35, "slimeball", 0.0f),
    SMOKING(36, "smoking", 0.0f),
    SNOWBALL(37, "snowball", 0.0f),
    TNT(38, "tnt", 3.0f),
    WATER_BOTTLE(39, "water_bottle", 1.0f);

    public static final Codec<ArrowTier> CODEC;
    private static final IntFunction<ArrowTier> BY_ID;
    private final int id;
    private final String name;
    private final float bonusDamage;

    private ArrowTier(int id, String name, float bonusDamage) {
        this.id = id;
        this.name = name;
        this.bonusDamage = bonusDamage;
    }

    public int getId() {
        return this.id;
    }

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public float bonusDamage() {
        return this.bonusDamage;
    }

    public static ArrowTier byId(int id) {
        return BY_ID.apply(id);
    }

    static {
        CODEC = StringRepresentable.fromEnum(ArrowTier::values);
        BY_ID = ByIdMap.continuous(ArrowTier::getId, (Object[])ArrowTier.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
    }

    private static class DamageConstant {
        public static final float LESSER_GEM = 2.0f;
        public static final float GREATER_GEM = 5.0f;
        public static final float LESSER_METAL = 3.0f;
        public static final float GREATER_METAL = 6.0f;

        private DamageConstant() {
        }
    }
}

